﻿
-- Simple Benutzung der Spalte ROWNUM
select rownum, ename, job
  from emp;
  
-- Rownum mit Projektion
select rownum, ename, job
  from emp
 where deptno = 20;
 
-- Fehlerhafter Versuch, die besten 5 Verdiener zu ermitteln
select rownum, ename, job, sal
  from emp
 where rownum < 6
 order by sal desc;
 
-- Sequenz erzeugen:
create sequence emp_seq;

-- Verwendung der Pseudospalte NEXTVAL und CURRVAL
select emp_seq.nextval
  from dual;
  
select emp_seq.currval
  from dual;
  
select emp_seq.nextval
  from dual;
 
-- Pseudosaplte ROWID
select rowid, ename, job
  from emp;
  
-- Pseudospalte ORA_ROWSCN
select ora_rowscn, ename, job
  from emp;